% Demonstration of a numerical integration of a set of two ordinary
% differential equations

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdt = f(t,c,k1,k2)

dcdt = zeros(2,1);     % Allocate space for the right-hand sides of the DEs

c1 = c(1);                % Concentration c1
c2 = c(2);                % Concentration c2

dcdt(1) = -k1*c1;             % Differential equation for concentration
dcdt(2) = -k2*c2;
